/* GLOBAL VARIABLES---------------------------------------------------------------------------*/

var CANVAS_WIDTH   = 1045, //440
    CANVAS_HEIGHT  = 790, //440
    D_WIDTH        = 1045,
    D_HEIGHT       = 700,
    D_START_X      = 50,
    D_START_Y      = 50, 
    START_POS_X    = 50,                                                  //initial position of a new name
    START_POS_Y    = 50,                                                  //initial position of a new name
    MAX_NAMES      = 100,                                                  //max number of names minus one to be added to the canvas
    paper          = null,      // init the Raphael canvas
    counter        = 0,                                                   //current number of names
    color          = null,     // initial color
    addName        = null,     // name value
    dotTipShown    = "nope",
    addNameExit    = null,     // abort add name
    nameSubmit     = null,     // name submit button
    editNameSubmit = null,     // edit name submit button
    editNameValue  = null,     // edit name new value
    newColor       = null,     // new color
	newSize        = null,     // new size
    generateImage  = null,     // not in use yet
    clear          = null,     // ref to the clear button 
    /*font1          = paper.getFont("Vera"), */                          // get the Raphael JS font 
    currentSet     = "";                                                  // a reference to the current Raphael Set
    clickedSet     = "";
    fontSize       = 16;
    currentName    = "";
	json = "";
    Raphael.registerFont({"w":90,"face":{"font-family":"TheMixPlainBold","font-weight":700,"font-stretch":"normal","units-per-em":"180","panose-1":"2 11 8 0 0 0 0 0 0 0","ascent":"144","descent":"-36","x-height":"2","bbox":"-6 -140.112 180 45","underline-thickness":"3.6","underline-position":"-23.4","unicode-range":"U+0020-U+2122"},"glyphs":{" ":{"w":39,"k":{"\u2018":12,"\u201c":12,"t":-1,"Y":3,"W":6,"V":3,"T":6}},"!":{"d":"41,-129r-27,0r4,95r19,0xm41,-12v0,-7,-7,-13,-14,-13v-7,0,-14,6,-14,13v-1,7,7,14,14,14v7,0,15,-7,14,-14","w":54},"\"":{"d":"31,-135r-23,0r3,46r17,0xm65,-135r-23,0r3,46r17,0","w":72},"#":{"d":"115,-32r0,-17r-23,0r3,-26r25,0r0,-17r-23,0r3,-30r-20,0r-3,30r-22,0r3,-30r-20,0r-3,30r-25,0r0,17r23,0r-3,26r-25,0r0,17r23,0r-3,32r20,0r3,-32r22,0r-3,32r20,0r3,-32r25,0xm72,-49r-22,0r3,-26r22,0","w":124},"$":{"d":"56,-31v0,19,-29,15,-42,10r-1,21v8,1,14,2,21,2r0,21r17,0r0,-22v31,-3,41,-51,11,-63v-10,-7,-28,-7,-30,-20v0,-16,24,-13,38,-9r1,-20v-6,-1,-12,-2,-18,-2r0,-17r-16,0r0,19v-16,3,-28,14,-29,31v-3,34,41,25,48,49","w":88},"%":{"d":"35,-63v18,0,31,-14,31,-33v0,-19,-10,-29,-29,-29v-18,-1,-32,13,-31,32v0,19,11,29,29,30xm37,-109v9,0,10,5,10,15v0,8,-4,15,-11,15v-7,-1,-10,-5,-10,-15v0,-8,4,-15,11,-15xm124,-114r-16,-12r-87,119r16,12xm108,4v18,0,31,-14,31,-33v0,-19,-11,-29,-30,-29v-17,-1,-31,14,-30,32v0,19,11,29,29,30xm109,-42v9,0,11,6,11,15v0,8,-4,15,-11,15v-7,-1,-11,-6,-11,-15v0,-8,4,-15,11,-15","w":146},"&":{"d":"8,-34v-2,43,65,43,89,21v6,5,14,10,24,17r15,-17r-22,-16v10,-14,16,-30,15,-54r-37,2v-2,12,3,15,14,15v0,10,-6,18,-9,25v-12,-9,-25,-21,-35,-31v26,-14,30,-61,-11,-61v-39,0,-46,43,-20,62v-12,10,-23,18,-23,37xm49,-116v19,2,9,26,-1,31v-10,-8,-17,-29,1,-31xm80,-26v-17,17,-60,6,-45,-21v2,-3,6,-6,10,-10","w":144},"'":{"d":"31,-135r-23,0r3,46r17,0","w":38},"(":{"d":"34,-138v-31,44,-33,129,0,173r22,0v-32,-48,-30,-127,-1,-173r-21,0","w":55,"k":{"y":-8,"l":-7,"k":-7,"j":-15,"h":-7,"b":-7,"a":1}},")":{"d":"22,35v32,-45,31,-128,0,-173r-22,0v30,45,33,125,0,173r22,0","w":55},"*":{"d":"63,-96r-18,-7r18,-7r-8,-14r-15,12r2,-19r-16,0r3,19r-15,-12r-8,14r18,7r-18,7r8,14r15,-12r-3,20r16,0r-2,-20r15,12","w":69,"k":{"l":-5,"k":-5,"h":-5,"b":-5}},"+":{"d":"98,-37r0,-19r-36,0r0,-37r-22,0r0,37r-36,0r0,19r36,0r0,37r22,0r0,-37r36,0","w":101,"k":{"+":-5}},",":{"d":"23,-27v-18,0,-14,21,-7,31v0,5,-4,11,-11,19r9,8v17,-11,38,-49,9,-58","w":46,"k":{"7":5,"4":-5,"1":2,"0":2,",":5," ":9}},"-":{"d":"52,-37r0,-18r-44,0r0,18r44,0","w":60,"k":{"Y":6,"X":2,"W":1,"V":5,"T":5,"S":2,"J":2,"9":-1,"8":-1,"7":5,"6":-2,"5":-1,"3":-1,"1":-1,"0":-2}},".":{"d":"38,-13v0,-8,-7,-14,-15,-14v-8,0,-15,7,-15,14v0,7,7,15,15,15v8,0,15,-7,15,-15","w":46,"k":{"\u2019":15,"\u201d":15,"y":13,"w":9,"v":14,"Y":17,"W":11,"V":15,"U":8,"T":12,"Q":5,"O":5,"J":-3,"G":5,"C":5,"7":3,"4":-5,".":3," ":7}},"\/":{"d":"73,-122r-22,0r-47,122r23,0","w":76,"k":{"z":5,"x":4,"u":5,"s":8,"r":2,"q":12,"p":2,"o":11,"n":2,"m":2,"l":-10,"k":-10,"j":2,"h":-10,"g":10,"e":9,"d":9,"c":10,"b":-10,"a":7,"Y":-3,"X":-1,"W":-4,"V":-5,"T":-2,"S":1,"Q":4,"O":4,"M":4,"J":7,"G":4,"C":4,"A":7,"9":6,"6":4,"5":4,"4":18,"3":2,"2":4,"1":4,"0":8}},"0":{"d":"53,2v31,0,48,-19,49,-49v1,-30,-15,-48,-46,-47v-29,1,-48,18,-48,49v0,31,16,47,45,47xm55,-75v16,0,24,11,24,28v1,16,-10,28,-24,29v-17,0,-25,-11,-25,-29v0,-16,11,-28,25,-28","w":109,"k":{"\u2013":-8,":":-3,"4":1,".":4,"-":-2,",":5}},"1":{"d":"48,0r0,-93v-21,-2,-31,6,-45,11r3,19r19,-8r0,71r23,0","w":61,"k":{"\u2013":-9,":":-3,"\/":-1,"-":-1}},"2":{"d":"13,-68v14,-15,51,-3,32,18v-5,7,-27,23,-37,31r0,19r71,0r0,-20r-39,0v15,-12,35,-23,35,-46v1,-30,-41,-32,-65,-22","w":86,"k":{"\u2013":-10,":":-4,"7":1,"\/":-3,"-":-1}},"3":{"d":"6,32v35,8,69,-8,69,-40v0,-15,-10,-26,-23,-28v30,-10,25,-58,-17,-58v-9,0,-18,2,-27,5r2,20v12,-8,38,-9,38,9v0,16,-17,19,-36,19r0,18v19,-1,39,0,38,18v0,18,-24,23,-42,17","w":82,"k":{"\u2013":-9,":":-4,"7":1,"\/":-3,",":-1}},"4":{"d":"97,0r0,-21r-19,0r0,-72r-29,0r-46,74r4,19r48,0r0,33r23,0r0,-33r19,0xm56,-21r-31,1r31,-51r0,50","w":99,"k":{"\u2013":-6,":":-7,"7":5,"6":2,"1":1,"\/":-6,".":-5,",":-5}},"5":{"d":"8,33v37,5,67,-10,68,-43v1,-23,-19,-37,-43,-36r0,-24r39,0r0,-23r-60,0r0,66v19,-4,40,3,40,20v0,18,-24,25,-42,19","w":83,"k":{"\u2013":-6,":":-4,"9":1,"7":1,"6":1,"4":1,"0":1,"\/":-3,".":-1,",":-1}},"6":{"d":"52,2v29,0,43,-17,46,-44v4,-36,-45,-49,-64,-27v3,-26,22,-42,52,-37r0,-20v-53,-3,-76,27,-77,76v0,31,16,52,43,52xm55,-60v13,0,18,9,18,21v0,12,-7,21,-19,21v-13,0,-19,-10,-19,-23v0,-11,7,-19,20,-19","w":104,"k":{"\u2013":-10,":":-5,"7":2,"-":-2}},"7":{"d":"45,33v7,-38,19,-74,33,-106r0,-20r-74,0r0,23r48,0v-12,30,-25,68,-33,103r26,0","w":82,"k":{"\u2013":-6,":":-3,"8":1,"6":1,"4":6,"0":1,".":11,",":11,"%":-2}},"8":{"d":"48,2v46,6,58,-55,21,-68v32,-14,24,-66,-18,-61v-42,-5,-56,50,-21,64v-33,13,-26,70,18,65xm50,-109v22,0,19,28,1,34v-9,-6,-16,-9,-18,-19v0,-8,7,-16,17,-15xm48,-53v10,5,19,9,20,21v0,9,-8,16,-18,15v-23,0,-22,-31,-2,-36","w":100,"k":{"\u2013":-8,":":-5,"7":1}},"9":{"d":"16,33v51,6,79,-24,79,-74v0,-33,-14,-53,-43,-53v-28,0,-42,17,-45,44v-3,35,42,50,62,28v-2,28,-25,41,-53,34r0,21xm50,-74v13,0,19,9,19,22v1,11,-8,20,-19,20v-13,1,-19,-8,-19,-21v-1,-12,8,-21,19,-21","w":104,"k":{"\u2013":-8,":":-4,"7":1,"-":-2}},":":{"d":"39,-64v0,-7,-7,-14,-14,-14v-8,0,-15,6,-15,14v0,8,7,15,15,15v8,0,14,-7,14,-15xm39,-13v0,-7,-7,-14,-14,-14v-8,0,-15,6,-15,14v0,8,7,15,15,15v8,0,14,-7,14,-15","w":49,"k":{"9":-5,"8":-5,"7":-1,"6":-3,"5":-3,"4":-5,"3":-4,"2":-4,"1":-4,"0":-3," ":8}},";":{"d":"25,-49v8,0,14,-7,14,-15v0,-7,-7,-14,-14,-14v-8,0,-15,6,-15,14v0,8,7,15,15,15xm16,31v17,-11,37,-49,9,-58v-30,7,6,35,-18,50","w":49,"k":{" ":7}},"<":{"d":"8,-45r58,53r15,-16r-43,-37r43,-39r-15,-15"},"=":{"d":"91,-53r0,-19r-80,0r0,19r80,0xm91,-19r0,-19r-80,0r0,19r80,0","w":102},">":{"d":"82,-46r-57,-53r-15,16r43,38r-43,38r15,15"},"?":{"d":"43,-34v-10,-29,28,-32,26,-59v-1,-25,-27,-36,-56,-37r-3,21v17,1,32,6,34,19v-5,20,-35,27,-24,56r23,0xm32,2v7,0,15,-7,14,-14v0,-7,-7,-13,-14,-13v-7,0,-14,6,-14,13v-1,7,7,14,14,14","w":77},"@":{"d":"98,-30v25,-1,39,-17,39,-43v0,-33,-24,-51,-58,-51v-43,0,-68,27,-70,70v-2,49,47,66,92,53r0,-17v-36,12,-73,-1,-73,-38v0,-53,87,-73,89,-16v0,15,-4,25,-16,26v-17,-4,-1,-35,-1,-45v-32,-10,-58,6,-58,39v0,32,34,24,39,7v1,9,6,15,17,15xm63,-46v-11,-7,-1,-42,18,-33v-2,15,-6,31,-18,33","w":145},"A":{"d":"112,0r-43,-122r-26,0r-43,122r24,0r8,-25r46,0r9,25r25,0xm72,-43r-34,0r17,-52v3,17,12,35,17,52","w":112,"k":{"\u2019":16,"\u2018":15,"\u201d":16,"\u201c":15,"y":1,"v":1,"f":1,"Y":15,"W":9,"V":10,"U":4,"T":13,"Q":3,"O":3,"M":-1,"J":-6,"G":3,"C":3,"A":-3,"\/":-4}},"B":{"d":"13,0v43,2,83,1,84,-37v0,-13,-9,-26,-22,-28v33,-13,19,-58,-21,-57r-41,1r0,121xm36,-103v17,-1,34,-1,34,15v0,16,-16,18,-34,17r0,-32xm36,-53v15,-3,37,0,36,16v0,17,-18,19,-36,18r0,-34","w":104,"k":{"Z":1,"Y":3,"X":3,"W":1,"V":2,"T":3,"R":-1,"Q":-1,"P":-1,"O":-1,"N":-1,"L":-1,"K":-1,"J":2,"I":-1,"H":-1,"F":-1,"E":-1,"D":-1,"B":-1,"A":2,".":4,",":3}},"C":{"d":"7,-57v0,50,44,70,87,53r-2,-21v-27,13,-65,1,-59,-36v-3,-34,27,-48,58,-37r2,-21v-49,-13,-86,12,-86,62","w":101,"k":{"z":1,"y":4,"x":3,"w":5,"v":5,"t":2,"o":2,"e":2,"a":1,"Z":3,"Y":2,"X":2,"W":4,"V":2,"T":1,"R":-1,"Q":5,"P":-1,"O":5,"N":-1,"L":-1,"K":-1,"I":-1,"H":-1,"G":5,"F":-1,"E":-1,"D":-1,"C":5,"B":-1,"A":1}},"D":{"d":"13,0v59,6,99,-9,100,-63v2,-55,-43,-65,-100,-58r0,121xm36,-102v32,-5,52,8,52,41v0,31,-21,46,-52,41r0,-82","w":120,"k":{"Z":5,"Y":7,"X":9,"W":3,"V":4,"T":6,"M":2,"J":6,"A":6,".":8,",":7}},"E":{"d":"79,0r0,-20r-43,0r0,-33r40,0r0,-19r-40,0r0,-30r43,0r0,-20r-66,0r0,122r66,0","w":88,"k":{"z":2,"y":2,"x":2,"v":1,"t":1,"s":1,"l":-2,"k":-2,"h":-2,"g":1,"f":2,"e":1,"d":1,"b":-2,"Z":1,"Y":2,"X":1,"W":1,"V":2,"J":1,"A":1}},"F":{"d":"78,-102r0,-20r-65,0r0,122r23,0r0,-51r39,0r0,-19r-39,0r0,-32r42,0","w":83,"k":{"\u2019":-1,"\u201d":-1,"y":2,"w":2,"u":1,"o":2,"l":-3,"k":-3,"h":-3,"g":2,"e":2,"d":1,"c":2,"b":-3,"a":4,"Z":4,"Y":1,"X":2,"W":1,"V":1,"U":1,"S":2,"Q":1,"O":1,"M":2,"J":9,"G":2,"C":2,"A":10,"\/":10,".":15,",":15}},"G":{"d":"32,-60v0,-39,40,-50,73,-36r4,-22v-51,-16,-103,7,-103,60v0,54,58,72,103,52r0,-58r-23,0r0,43v-30,8,-54,-8,-54,-39","w":121,"k":{"Z":1,"Y":3,"X":2,"W":2,"V":2,"T":2,"A":1}},"H":{"d":"111,0r0,-122r-24,0r0,49r-51,0r0,-49r-23,0r0,122r23,0r0,-53r51,0r0,53r24,0","w":123,"k":{"l":-2,"k":-2,"h":-2,"b":-2,"Y":1,"U":-3,"T":1,"R":-3,"P":-3,"N":-3,"L":-3,"K":-3,"I":-3,"H":-3,"F":-3,"E":-3,"D":-3,"B":-3}},"I":{"d":"36,0r0,-122r-23,0r0,122r23,0","w":48,"k":{"l":-2,"k":-2,"h":-2,"b":-2,"Y":1,"U":-3,"T":1,"R":-3,"P":-3,"N":-3,"L":-3,"K":-3,"I":-3,"H":-3,"F":-3,"E":-3,"D":-3,"B":-3}},"J":{"d":"0,0v28,7,48,-6,48,-34r0,-88r-24,0r0,87v2,17,-12,19,-24,15r0,20","w":60,"k":{"l":-2,"k":-2,"h":-2,"b":-2,"Z":3,"Y":3,"X":2,"W":1,"V":1,"U":-3,"T":1,"S":1,"R":-3,"P":-3,"N":-3,"M":3,"L":-3,"K":-3,"J":4,"I":-3,"H":-3,"F":-3,"E":-3,"D":-3,"B":-3,"A":3,"\/":2,".":4,",":3}},"K":{"d":"106,0r-47,-63r45,-59r-29,0r-39,56r0,-56r-23,0r0,122r23,0r0,-58r39,58r31,0","w":107,"k":{"y":7,"w":6,"v":8,"u":5,"o":4,"l":-2,"k":-2,"h":-2,"g":2,"e":4,"d":2,"c":2,"b":-2,"a":2,"Z":2,"Y":1,"W":2,"V":1,"U":2,"S":3,"Q":7,"O":7,"J":-2,"G":6,"C":6,"-":10}},"L":{"d":"75,0r0,-21r-39,0r0,-101r-23,0r0,122r62,0","w":77,"k":{"\u2019":19,"\u2018":16,"\u201d":19,"\u201c":16,"y":10,"w":7,"v":9,"u":2,"t":2,"o":1,"e":1,"Z":2,"Y":17,"W":10,"V":12,"U":2,"T":15,"S":3,"Q":4,"O":4,"J":-3,"G":4,"C":4,"A":-2,"\/":-3,".":-1,"-":3}},"M":{"d":"153,0r-19,-122r-27,0r-28,89v-7,-31,-18,-59,-27,-89r-28,0r-18,122r24,0r10,-87v6,31,18,58,26,87r24,0r26,-87r12,87r25,0","w":158,"k":{"\u2019":6,"\u2018":3,"\u201d":6,"\u201c":3,"y":1,"Z":2,"Y":8,"W":2,"V":4,"U":1,"T":7,"Q":1,"O":1,"J":-3,"A":-1,"\/":-1}},"N":{"d":"113,0r0,-122r-22,0r1,87v-15,-30,-32,-58,-49,-87r-30,0r0,122r22,0r-1,-87v15,33,32,57,49,87r30,0","w":125,"k":{"l":-2,"k":-2,"h":-2,"b":-2,"Y":1,"U":-3,"T":1,"R":-3,"P":-3,"N":-3,"L":-3,"K":-3,"I":-3,"H":-3,"F":-3,"E":-3,"D":-3,"B":-3}},"O":{"d":"61,2v39,-1,59,-26,60,-64v2,-38,-20,-61,-56,-61v-39,1,-59,26,-59,64v0,37,18,62,55,61xm63,-102v22,0,33,17,33,41v0,24,-11,41,-33,42v-23,1,-32,-19,-32,-43v-1,-23,11,-40,32,-40","w":126,"k":{"x":2,"f":-2,"Z":4,"Y":6,"X":6,"W":3,"V":5,"T":7,"Q":-1,"O":-1,"M":2,"J":4,"G":-1,"C":-1,"A":4,"\/":3,".":6,",":6}},"P":{"d":"36,-43v30,3,55,-12,55,-42v0,-37,-38,-39,-78,-37r0,122r23,0r0,-43xm36,-103v18,-1,31,4,31,20v-1,15,-13,23,-31,21r0,-41","w":95,"k":{"\u2019":-3,"\u201d":-3,"t":-2,"o":2,"g":3,"f":-3,"e":2,"d":2,"c":2,"a":3,"Z":4,"Y":1,"X":5,"V":1,"T":1,"S":1,"Q":1,"O":1,"M":4,"J":8,"A":12,":":3,"\/":12,".":22,"-":3,",":20}},"Q":{"d":"61,2v39,-1,59,-26,60,-64v2,-38,-20,-61,-56,-61v-39,1,-59,26,-59,64v0,37,18,62,55,61xm54,32v26,-4,45,10,72,5r0,-21v-26,5,-46,-10,-72,-5r0,21xm63,-102v22,0,33,17,33,41v0,24,-11,41,-33,42v-23,1,-32,-19,-32,-43v-1,-23,11,-40,32,-40","w":126,"k":{"}":-9,"]":-7,"Z":3,"Y":5,"X":4,"W":1,"V":3,"T":2,"Q":-1,"O":-1,"A":3,";":-7,"\/":1,".":4,",":-7,")":-11}},"R":{"d":"92,-88v1,-38,-41,-34,-79,-34r0,122r23,0v1,-16,-2,-36,1,-50r34,50r29,0r-39,-54v16,-3,31,-16,31,-34xm67,-86v0,16,-16,21,-31,18r0,-35v17,-1,31,2,31,17","w":102,"k":{"y":1,"u":1,"o":2,"g":1,"e":2,"d":1,"c":1,"a":1,"Z":3,"Y":5,"W":3,"V":4,"T":5,"R":-1,"Q":2,"P":-1,"O":2,"N":-1,"L":-1,"K":-1,"J":-1,"I":-1,"H":-1,"G":1,"F":-1,"E":-1,"D":-1,"C":1,"B":-1,"A":-1,"\/":-3,"-":7}},"S":{"d":"10,-1v33,9,73,-2,73,-37v0,-36,-44,-26,-51,-51v0,-18,26,-17,42,-12r1,-20v-32,-8,-68,4,-68,34v0,36,45,27,51,53v0,21,-30,17,-46,11","k":{"y":3,"w":3,"v":4,"Z":3,"Y":6,"X":3,"W":5,"V":6,"T":6,"J":2,"A":2,"\/":2,".":2,",":3}},"T":{"d":"89,-102r0,-20r-86,0r0,20r31,0r0,102r24,0r0,-102r31,0","w":91,"k":{"\u2019":-2,"\u201d":-2,"\u2014":6,"z":12,"y":11,"x":12,"w":10,"v":9,"u":7,"s":13,"r":5,"q":12,"p":5,"o":13,"n":5,"m":5,"l":-2,"k":-2,"h":-2,"g":12,"e":13,"d":13,"c":14,"b":-2,"a":10,"Z":2,"X":1,"U":1,"S":2,"R":2,"Q":7,"P":2,"O":7,"N":2,"M":7,"L":2,"K":2,"J":9,"I":2,"H":2,"G":8,"F":2,"E":2,"D":2,"C":8,"B":2,"A":13,";":10,":":10,"\/":13,".":11,"-":10,",":14}},"U":{"d":"60,2v62,0,49,-67,50,-124r-23,0v-5,38,17,105,-26,105v-43,0,-19,-67,-25,-105r-23,0v2,55,-16,124,47,124","w":122,"k":{"l":-4,"k":-4,"h":-4,"b":-4,"Z":1,"Y":3,"X":2,"W":1,"V":2,"T":2,"R":-3,"P":-3,"N":-3,"M":1,"L":-3,"K":-3,"J":3,"I":-3,"H":-3,"F":-3,"E":-3,"D":-3,"B":-3,"A":6,"\/":5,".":3,",":2}},"V":{"d":"112,-122r-24,0r-31,95r-31,-95r-25,0r42,122r27,0","w":113,"k":{"z":9,"y":5,"x":1,"u":1,"s":9,"r":3,"q":11,"p":3,"o":11,"n":3,"m":3,"l":-4,"k":-4,"h":-4,"g":10,"e":10,"d":9,"c":9,"b":-4,"a":8,"Z":3,"U":1,"S":3,"Q":5,"O":5,"M":5,"J":10,"G":6,"C":6,"A":9,";":9,":":7,"\/":9,".":16,"-":8,",":16}},"W":{"d":"167,-122r-24,0r-21,92v-6,-32,-15,-61,-23,-92r-25,0r-24,92v-4,-34,-14,-61,-21,-92r-25,0r31,122r27,0r23,-92v5,38,14,59,22,92r29,0","w":171,"k":{"z":7,"y":2,"x":6,"u":2,"s":7,"r":2,"q":3,"p":2,"o":7,"n":2,"m":2,"g":8,"e":6,"d":7,"c":7,"a":6,"Z":4,"U":1,"S":1,"R":1,"Q":3,"P":1,"O":3,"N":1,"M":2,"L":1,"K":1,"J":8,"I":1,"H":1,"G":4,"F":1,"E":1,"D":1,"C":4,"B":1,"A":9,";":6,":":5,"\/":8,".":13,"-":6,",":12}},"X":{"d":"111,0r-40,-62r36,-60r-27,0r-24,43r-25,-43r-27,0r36,60r-38,62r28,0r26,-45r26,45r29,0","w":113,"k":{"\u2018":1,"\u201c":1,"y":4,"u":3,"o":4,"e":4,"c":1,"a":1,"Z":2,"Y":2,"X":-2,"W":1,"V":1,"U":3,"T":3,"S":3,"R":1,"Q":7,"P":1,"O":7,"N":1,"L":1,"K":1,"J":-4,"I":1,"H":1,"G":8,"F":1,"E":1,"D":1,"C":8,"B":1,";":-2,"\/":-2,".":-2,"-":3}},"Y":{"d":"101,-122r-25,0v-9,18,-15,39,-26,56v-7,-20,-16,-38,-24,-56r-25,0r38,79r0,43r23,0r0,-43","w":100,"k":{"\u2014":6,"z":12,"x":8,"w":6,"v":7,"u":6,"t":5,"s":14,"r":4,"q":15,"p":4,"o":15,"n":4,"m":4,"l":-4,"k":-4,"h":-4,"g":13,"e":14,"d":13,"c":14,"b":-4,"a":12,"Z":4,"X":2,"V":-2,"U":2,"S":3,"R":1,"Q":7,"P":1,"O":7,"N":1,"M":8,"L":1,"K":1,"J":11,"I":1,"H":1,"G":9,"F":1,"E":1,"D":1,"C":9,"B":1,"A":15,";":12,":":12,"\/":15,".":17,"-":9,",":14}},"Z":{"d":"89,0r0,-22r-53,1r52,-82r0,-19r-78,0r0,22r50,-1r-52,83r0,18r81,0","w":96,"k":{"\u2019":-1,"\u201d":-1,"y":3,"w":1,"v":2,"u":2,"t":2,"s":2,"o":3,"l":-1,"k":-1,"h":-1,"e":2,"c":1,"b":-1,"a":1,"Y":2,"X":1,"W":1,"V":1,"U":1,"T":1,"S":1,"Q":4,"O":4,"M":2,"J":-2,"G":4,"C":4,"A":1,"\/":-1,"-":2}},"[":{"d":"53,37r0,-19r-19,0r0,-140r19,0r0,-18r-40,0r0,177r40,0","w":59,"k":{"y":-5,"l":-5,"k":-5,"j":-12,"h":-5,"b":-5,"Q":2,"O":2,"G":3,"C":3}},"\\":{"d":"72,0r-48,-122r-21,0r47,122r22,0","w":74},"]":{"d":"46,37r0,-177r-40,0r0,18r18,0r0,140r-18,0r0,19r40,0","w":59},"^":{"d":"87,-69r-31,-53r-18,0r-29,53r15,8r23,-44r23,44","w":96},"_":{"d":"90,45r0,-18r-90,0r0,18r90,0"},"`":{"d":"56,-114r-31,-20r-10,16r33,17","w":67},"a":{"d":"7,-22v-2,31,46,30,54,7v-1,4,-1,9,-1,15v12,0,26,1,37,-1v2,-13,-2,-18,-15,-17v0,-38,7,-73,-37,-73v-12,0,-23,1,-32,5r2,19v13,-8,47,-14,43,12v-27,0,-50,10,-51,33xm58,-40v5,20,-25,34,-29,15v0,-14,15,-13,29,-15","w":99,"k":{"y":2,"x":-2,"w":2,"v":5,"u":1,"t":1}},"b":{"d":"95,-49v8,-40,-45,-56,-60,-26r1,-57r-38,2v-3,13,3,16,15,16r0,111v38,14,86,-2,82,-46xm36,-18v0,-24,-2,-52,19,-54v23,3,22,59,-7,55v-5,0,-9,0,-12,-1","w":101,"k":{"z":1,"y":1,"x":2,"v":1,".":6,",":3}},"c":{"d":"6,-42v0,38,32,52,65,39r-2,-19v-17,9,-39,2,-39,-22v0,-23,17,-34,38,-25r3,-20v-37,-9,-65,11,-65,47","w":76,"k":{"\u2019":-3,"\u201d":-3,"u":-1,"t":-2,"r":-1,"p":-1,"o":2,"n":-1,"m":-1,"j":-2,"i":-1,"f":-2,"e":1,"c":1,"\/":-3,".":-2,"(":-1}},"d":{"d":"6,-40v0,42,46,54,62,25v-1,5,-2,10,-2,15v13,0,27,1,38,-1r0,-15r-16,-2r0,-114r-39,2r0,14r16,2r0,24v-36,-6,-59,16,-59,50xm46,-17v-23,-3,-22,-60,7,-56v4,0,8,1,12,2v1,24,2,52,-19,54","w":105,"k":{"y":3,"x":-1,"v":2,"l":-1,"k":-1,"h":-1,"b":-1}},"e":{"d":"80,-22v-18,9,-53,10,-50,-19r55,0v4,-28,-9,-50,-37,-50v-27,0,-42,20,-42,47v0,44,41,55,76,40xm30,-57v1,-15,18,-24,29,-13v3,3,4,7,4,13r-33,0","w":92,"k":{"z":1,"y":1,"x":1,"w":1,"v":1,".":-1}},"f":{"d":"40,-89v-4,-20,9,-30,26,-23r1,-19v-30,-7,-55,7,-50,42r-16,0r0,17r16,0r0,72r23,0r0,-72r21,0r0,-17r-21,0","w":63,"k":{"\u2019":-7,"\u2018":-5,"\u201d":-7,"\u201c":-5,"}":-8,"y":-1,"w":-1,"v":-1,"t":5,"s":2,"r":-1,"q":3,"p":-1,"o":3,"n":-1,"m":-1,"g":1,"f":5,"e":3,"d":4,"c":3,"a":4,"]":-9,"?":-4,";":4,":":3,"\/":2,".":9,"-":5,",":9,")":-9,"'":-6,"!":-2}},"g":{"d":"65,-2v0,33,-32,30,-52,22r-2,21v36,9,77,2,77,-38r0,-91v-43,-11,-82,4,-82,48v0,40,43,56,60,25v-1,3,-1,7,-1,13xm46,-17v-23,-3,-22,-60,7,-56v5,0,9,1,12,2v1,24,1,52,-19,54","w":99,"k":{"j":-2,"e":1,"c":1,"a":1,".":-3,",":-4}},"h":{"d":"91,0v0,-42,11,-109,-44,-87v-5,3,-9,7,-12,12r1,-57r-38,2v-3,13,3,16,15,16r0,114r23,0v1,-30,-7,-70,21,-72v22,4,7,49,11,72r23,0","w":103,"k":{"\u2019":2,"\u201d":2,"y":2,"x":2,"w":1,"v":2,"t":1}},"i":{"d":"30,-101v7,1,14,-7,14,-14v0,-7,-7,-15,-14,-14v-8,0,-15,7,-15,14v0,7,7,14,15,14xm41,-90r-38,2v-3,13,3,16,15,16r0,72r23,0r0,-90","w":53,"k":{"l":-3,"k":-3,"h":-3,"b":-3}},"j":{"d":"30,-101v7,0,14,-7,14,-14v0,-7,-7,-14,-14,-14v-7,0,-14,7,-14,14v0,7,7,14,14,14xm-6,43v28,7,48,-5,48,-36r0,-97v-14,0,-28,1,-39,2v-3,13,4,16,16,16r0,81v2,16,-10,18,-23,14","w":54,"k":{"l":-2,"k":-2,"j":-3,"h":-2,"b":-2}},"k":{"d":"93,0r-34,-49r32,-40r-29,0r-26,37r0,-80r-38,2v-3,13,3,16,15,16r0,114r23,0r0,-44r28,44r29,0","w":94,"k":{"z":1,"y":1,"v":2,"u":2,"s":1,"q":3,"o":3,"g":2,"e":3,"d":4,"c":3,"a":3,"-":8}},"l":{"d":"36,-132r-38,2v-3,13,3,16,15,16r0,114r23,0r0,-132","w":48,"k":{"l":-3,"k":-3,"h":-3,"b":-3}},"m":{"d":"93,-73v-4,-25,-49,-22,-54,0r1,-17r-37,2v-3,13,3,16,15,16r0,72r23,0v0,-30,-6,-70,21,-72v20,6,6,49,10,72r23,0v0,-30,-6,-70,21,-72v20,6,6,49,10,72r23,0v-3,-36,13,-91,-27,-91v-14,0,-25,9,-29,18","w":161,"k":{"\u2019":2,"\u201d":2,"y":2,"x":2,"w":1,"v":2,"t":1}},"n":{"d":"96,-63v5,-38,-51,-31,-57,-11r1,-16r-37,2v-3,13,3,16,15,16r0,72r23,0v1,-30,-7,-70,21,-72v22,4,7,49,11,72r23,0r0,-63","w":108,"k":{"\u2019":2,"\u201d":2,"y":2,"x":2,"w":1,"v":2,"t":1}},"o":{"d":"48,2v28,0,45,-18,45,-48v0,-29,-13,-44,-41,-45v-30,0,-45,19,-46,48v-1,29,14,45,42,45xm50,-72v15,0,19,10,20,27v0,15,-7,27,-20,27v-13,0,-20,-10,-20,-28v0,-16,7,-26,20,-26","w":99,"k":{"y":1,"x":4,"w":1,"v":2,".":4,",":4}},"p":{"d":"100,-50v0,-40,-47,-54,-61,-25r1,-15r-37,2v-3,13,3,16,15,16r0,115r23,0r0,-42v39,4,59,-15,59,-51xm41,-18v-1,-24,-2,-52,19,-54v30,11,16,67,-19,54","w":106,"k":{"y":1,"x":3,"v":1,".":2,",":4}},"q":{"d":"6,-40v-6,40,45,56,60,26v-1,18,-1,38,-1,58r39,-2r0,-14r-16,-2r0,-114v-43,-11,-84,4,-82,48xm31,-42v-1,-24,11,-35,34,-30v1,24,2,53,-19,55v-10,0,-15,-8,-15,-25","w":100,"k":{"j":-6,")":-11}},"r":{"d":"67,-91v-13,-5,-23,11,-29,20v1,-6,3,-12,2,-19r-37,2v-3,13,3,16,15,16r0,72r23,0v1,-29,-8,-76,25,-69","w":69,"k":{"y":-1,"w":-2,"v":-2,"u":-2,"t":-3,"r":-2,"q":3,"p":-2,"o":2,"n":-2,"m":-2,"j":-2,"i":-2,"f":-3,"e":1,"d":1,"c":1,"a":3,";":1,":":1,".":11,"-":3,",":11}},"s":{"d":"9,0v28,6,58,-1,59,-28v1,-27,-33,-19,-37,-37v-2,-11,21,-10,30,-7r1,-18v-28,-4,-54,3,-55,27v-1,26,30,21,37,37v-1,13,-23,11,-34,7","w":75,"k":{"y":1,"x":4,"w":1,"v":3,"a":1,",":3,")":2}},"t":{"d":"17,-72v0,39,-9,90,44,71r0,-18v-30,10,-21,-28,-22,-53r22,0r0,-17r-22,0r0,-34r-23,6r0,28r-15,0r0,17r16,0","w":67,"k":{"\u2019":-2,"\u201d":-2,"o":1,"d":1,"\/":-3,".":-3,"-":2," ":-1}},"u":{"d":"18,-27v-4,36,48,36,57,11r-1,16v12,0,26,1,37,-1v2,-13,-2,-18,-15,-17r0,-71r-23,0v0,30,6,69,-21,72v-22,-4,-7,-49,-11,-73r-39,2r0,14r16,2r0,45","w":113,"k":{"y":2,"x":-2,"w":2,"v":3}},"v":{"d":"91,-89r-25,0r-20,60r-20,-60r-25,0r33,89r23,0","w":91,"k":{"y":-2,"w":-2,"v":-2,"u":-2,"t":-2,"s":2,"r":-1,"q":3,"p":-1,"o":3,"n":-1,"m":-1,"g":1,"f":-1,"e":2,"d":3,"c":3,"a":4,":":1,"\/":4,".":12,"-":2,",":11}},"w":{"d":"141,-89r-23,0r-17,60v-5,-21,-11,-41,-18,-60r-22,0v-7,19,-12,41,-18,60r-16,-60r-25,0r27,89r24,0r17,-60v5,24,11,39,18,60r25,0","w":143,"k":{"w":-2,"v":-2,"u":-2,"t":-4,"s":2,"r":-1,"p":-1,"o":2,"n":-1,"m":-1,"g":1,"f":-2,"e":2,"d":1,"c":1,"a":3,"\/":2,".":10,"-":1,",":11}},"x":{"d":"93,0r-29,-45r27,-44r-25,0r-17,29r-18,-29r-27,0r29,44r-31,45r28,0r17,-30r17,30r29,0","w":95,"k":{"q":3,"o":3,"f":-2,"e":2,"d":2,"c":2,"a":1,"\/":-5,".":-2,"-":2}},"y":{"d":"90,-89r-25,0r-19,58v-6,-23,-12,-37,-19,-58r-26,0r33,89v-3,17,-12,31,-33,23r-1,20v31,8,44,-12,53,-35","k":{"\u2018":-1,"\u201c":-1,"y":-1,"v":-1,"u":-1,"t":-3,"s":1,"r":-2,"q":4,"p":-2,"o":3,"n":-2,"m":-2,"j":-2,"g":2,"f":-4,"e":2,"d":3,"c":4,"a":4,";":2,":":2,".":14,"-":1,",":13}},"z":{"d":"73,0r0,-21r-36,0r35,-52r0,-16r-63,0r0,20r35,0r-36,53r0,16r65,0","w":81,"k":{"o":2,"e":1,"d":1,"c":2,"a":1,"\/":-2,"-":2}},"{":{"d":"23,-28v-1,36,-1,68,36,65r0,-19v-33,2,2,-68,-31,-75v30,0,0,-65,31,-65r0,-18v-33,-2,-37,23,-36,56v0,14,-6,18,-18,19r0,17v12,1,19,6,18,20","w":65,"k":{"l":-3,"k":-3,"h":-3,"b":-3,"J":-4}},"|":{"d":"34,45r0,-180r-19,0r0,180r19,0","w":49,"k":{"|":9}},"}":{"d":"43,-3v0,-21,-4,-47,18,-45r0,-17v-19,1,-18,-16,-18,-35v0,-28,-9,-40,-37,-40r0,18v31,-1,2,62,32,66v-32,0,2,73,-32,74r0,19v28,0,36,-12,37,-40","w":64},"~":{"d":"14,-37v22,-21,60,21,82,-9r-7,-17v-23,26,-55,-20,-82,9","w":103},"\u2122":{"d":"118,-71r-9,-51r-19,0r-8,30r-7,-30r-20,0r-8,51r15,0v1,-10,4,-19,4,-30r8,30r15,0v2,-10,6,-19,7,-30r5,30r17,0xm46,-108r0,-14r-41,0r0,14r12,0r0,37r17,0r0,-37r12,0","w":124},"\u2026":{"d":"38,-13v0,-8,-7,-14,-15,-14v-8,0,-15,7,-15,14v0,7,7,15,15,15v8,0,15,-7,15,-15xm81,-13v0,-7,-7,-14,-14,-14v-8,0,-15,6,-15,14v0,8,7,15,15,15v8,0,14,-7,14,-15xm125,-13v0,-18,-30,-18,-30,0v0,7,7,15,15,15v8,0,15,-8,15,-15","w":134},"\u2013":{"d":"90,-42r0,-20r-90,0r0,20r90,0","k":{"9":-8,"8":-8,"7":-5,"6":-8,"5":-8,"4":-8,"3":-8,"2":-4,"1":-6,"0":-8}},"\u2014":{"d":"180,-42r0,-20r-180,0r0,20r180,0","w":180},"\u201c":{"d":"63,-78v17,0,13,-21,7,-30v0,-5,4,-12,11,-20r-10,-8v-16,12,-37,50,-8,58xm23,-78v30,-7,-6,-35,18,-50r-9,-8v-17,11,-37,49,-9,58","w":87,"k":{"\u2018":8,"\u201c":8,"y":-2,"t":-3,"s":4,"q":7,"o":7,"l":-4,"k":-4,"h":-4,"g":6,"f":-2,"e":8,"d":8,"c":7,"b":-4,"a":2,"Q":1,"O":1,"M":5,"J":8,"G":1,"C":1,"A":17}},"\u201d":{"d":"24,-134v-18,0,-12,20,-7,30v0,5,-4,11,-11,19r10,9v12,-11,21,-24,23,-41v1,-10,-6,-18,-15,-17xm64,-134v-18,0,-14,21,-7,30v0,5,-4,11,-11,19r9,9v12,-11,23,-22,23,-41v1,-9,-5,-18,-14,-17","w":87,"k":{"\u2019":7,"\u201d":7,"v":-2,"u":5,"s":11,"q":11,"o":10,"l":-8,"k":-8,"h":-8,"g":11,"e":8,"d":17,"c":8,"b":-8,"a":4,"Q":6,"O":6,"M":6,"J":10,"G":6,"C":6,"A":22,".":16,",":16," ":11}},"\u2018":{"d":"23,-78v30,-7,-6,-35,18,-50r-9,-8v-17,11,-37,49,-9,58","w":48,"k":{"\u2018":8,"\u201c":8,"y":-2,"t":-3,"s":4,"q":7,"o":7,"l":-4,"k":-4,"h":-4,"g":6,"f":-2,"e":8,"d":8,"c":7,"b":-4,"a":2,"Q":1,"O":1,"M":5,"J":8,"G":1,"C":1,"A":17}},"\u2019":{"d":"24,-134v-18,0,-12,20,-7,30v0,5,-4,11,-11,19r10,9v12,-11,21,-24,23,-41v1,-10,-6,-18,-15,-17","w":48,"k":{"\u2019":7,"\u201d":7,"v":-2,"u":5,"s":11,"q":11,"o":10,"l":-8,"k":-8,"h":-8,"g":11,"e":8,"d":17,"c":8,"b":-8,"a":4,"Q":6,"O":6,"M":6,"J":10,"G":6,"C":6,"A":22,".":16,",":16," ":11}},"\u00a0":{"w":39,"k":{"\u2018":12,"\u201c":12,"t":-1,"Y":3,"W":6,"V":3,"T":6}}}});
  

var onJSReady = function(mapsData) {	
	
// EVENT LISTENERS--------------------------------------------------------------------------------

//$( document ).ready(function() {
       init();
	   
	   //---------------- Current Orientation -------------
	   for (key in mapsData.I)
	   {
			//alert( key + ": " + mapsData.C[key]);
			redrawNameSet(mapsData.I['otype'],mapsData.I['name'],mapsData.I['SHid'],mapsData.I['Orientation'],mapsData.I['Size'],mapsData.I['id'],mapsData.I['positionX'],mapsData.I['positionY'],mapsData.I['positionX2'],mapsData.I['positionY2'],mapsData.I['width'],mapsData.I['height'],mapsData.I['positionCX'],mapsData.I['positionCY']);
	   }
	   //---------------- Current Orientation -------------
	   for (key in mapsData.C)
	   {
			//alert( key + ": " + mapsData.C[key]);
			redrawNameSet(mapsData.C['otype'],mapsData.C['name'],mapsData.C['SHid'],mapsData.C['Orientation'],mapsData.C['Size'],mapsData.C['id'],mapsData.C['positionX'],mapsData.C['positionY'],mapsData.C['positionX2'],mapsData.C['positionY2'],mapsData.C['width'],mapsData.C['height'],mapsData.C['positionCX'],mapsData.C['positionCY']);
	   }
	   //---------------- Desired Orientation -------------
	   for (key in mapsData.D)
	   {
			//alert( key + ": " + mapsData.D[key]);
			redrawNameSet(mapsData.D['otype'],mapsData.D['name'],mapsData.D['SHid'],mapsData.D['Orientation'],mapsData.D['Size'],mapsData.D['id'],mapsData.D['positionX'],mapsData.D['positionY'],mapsData.D['positionX2'],mapsData.D['positionY2'],mapsData.D['width'],mapsData.D['height'],mapsData.D['positionCX'],mapsData.D['positionCY']);
	   }
	   //--------------------------------------------------
	  
      //change the z-index for IE7 to make the app_container visible
      if (navigator.appVersion.indexOf("MSIE 7.")!=-1) {
        $("#app_container").css("z-index", "1000");
      }	  
		  
      //generateSVG(mapsData['SHid']);
	  
	  //$("#generateSVG").trigger('click');

      //show the add name form
      $("#addName").click(function(e) {
        //e.preventDefault();

        if (navigator.appVersion.indexOf("MSIE 7.")!=-1) {
          // if IE7 use normal Jvascript to change the css
          document.getElementById("addNameBox").style.display="block";
          document.getElementById("addNameForm").style.display="block";
          $("#addNameBox").css("z-index", "1000");

        } else {
          $("#editNameBox form").fadeOut();
          $("#addNameBox").fadeIn();
          $("#addNameBox form").fadeIn();
        }
          addName.value="";
          $("#name").focus(); //focus on the name edit field when the form pops up
      });  

      $("#exitAddName").click(function(e) {
          e.preventDefault();
          $("#addNameBox form").fadeOut();
      });
      
      // hide the edit name form
      $("#exitEdit").click(function(e) {
        e.preventDefault();
        $("#editNameBox form").fadeOut();
        currentSet[1].attr({fill: currentSet[1].data("color")});
      });

      $('#ajax_test').click(function(e) {		
		
		var paperelements = [];
		//---------------------------
		for ( var el = paper.bottom; el != null; el = el.next ) 
		{				
			if(el.type == 'circle')
			{
				nname = el.data("shname");
				nshid = el.data("shid");
				nsize = el.data("shsize");
				ncolor = el.attr("fill");				
				nposition = el.getBBox();
				
				paperelements.push({name:nname,shid: nshid,size:nsize,color:ncolor,position:nposition});
			}
		}
		
		var jsondata = paper.toJSON();
		var jsonElementsString = JSON.stringify(paperelements);
		
		var shid = $('#lastshid').val();
		
        e.preventDefault();
        $.ajax({
              url : 'svgdiagram/ajax.php',
              type: "POST",
              data : 'action=save'+'&jsonElementsString='+jsonElementsString+'&jsondata='+jsondata+'&svg=' + encodeURIComponent(paper.toSVG()),
              success: function(data, textStatus, jqXHR) {      
                
                data = $.trim(data);
				
                if(data == 'OK'){
                 	
					Lobibox.notify('success', {
                    title: 'Success',
                    msg: 'Data save successfully'
					
                });
                }
                
              },
              error: function (jqXHR, textStatus, errorThrown){
                //alert('ERROR');

              },
              complete:function(jqXHR,textStatus){ 
                //
              }
            }); 
      });

      $("#nameSubmit").click(function( event ) {
        event.preventDefault();

        if (counter <= MAX_NAMES) {
          if (addName.value != "") {
            
			var theName = addName.value;
            //var theColor   = color.value;
			//var theSize   = size.value;
			
            currentSet = createNewNameSet(theName);
			
            counter++; 
            $("#addNameBox form").fadeOut(); 
            if(dotTipShown == "nope") {
                show_hint_about_the_dot_once();
                dotTipShown = "yep";
            }
            
          }
          else {
           //empty
          }
        } else {
          alert("20 Names, no more!"); //max number of names for this app reached
        }
       
    });
	
	  $("#nameCancel").click(function( event ) {
									
        $("#addNameBox form").fadeOut();
       
      });
	
	  $("#nameEditCancel").click(function( event ) {
		
		$("#editNameBox form").fadeOut();
       
      });		

      $("#nameEdit").click(function( event ) {
        event.preventDefault();
				
        var thisSet  = currentSet;
        var newName  = editNameValue.value;
        //var color    = newColor.value;
		var color    = $("input[name='newStrokeStyleSelect']:checked").val();
		//var nSize    = newSize.value;
		var nSize    = $("input[name='strokeNewSizeSelect']:checked").val();
        var oldDotPos = thisSet[0].getBBox();
        
        //thisSet.remove();
        var thisSet = deleteAndCreateNewSet(newName, color, oldDotPos,nSize);
		
        currentSet = thisSet;

        //repositionElements();
        $("#editNameBox form").fadeOut();      
    });
        
      //clear the grid
       /* clear.onclick = function (e) {
      //e.preventDefault();
      paper.clear();
      init();
      counter = 0;
      $("#addNameBox form").fadeOut();
      $("#editNameBox form").fadeOut();
    }*/
      // code to create a svg element from the Raphael graphic

}; //end onJSReady


// FUNCTIONS----------------------------------------------------------------------------
		
createNewNameSet = function(name) {
    var mySet = paper.set(); //define a Raphael Set of vector objects to be passed to draggable
    var theName = name;
	
    var curshid = $('#curshid').val();
	$('#lastshid').val(curshid);
	
	var curshidValue = $('#curshid').val();
	var curshnameValue = $('#shname').val();	
	var curshOrientationValue = $("input[name='strokeStyleSelect']:checked").val();
	var curshSizeValue = $("input[name='strokeSizeSelect']:checked").val();
	
	theDot = paper.circle(0,0,4);
	theDot.attr({fill: curshOrientationValue,'cursor':'crosshair'});
	theDot.data('shname', theName);
	theDot.data('shid', curshid);
	theDot.data('shsize', curshSizeValue);

    //var text = paper.print(0, 0, theName, '').attr({"stroke-width": 0, fill: curshOrientationValue, "font-family": "the_mix_bold-bold, Times", "font-weight": "normal", "font-size":90});
	var text = paper.text(0, 0, theName).attr({"stroke-width": 0, fill: curshOrientationValue, "font-family": "the_mix_bold-bold, Times", "font-weight": "normal", "font-size":curshSizeValue});
    text.data('name', theName);       //save the name in the Set
    text.data('color', curshOrientationValue);  //and the color
	text.attr({"font-size": curshSizeValue, 'text-anchor': 'start','cursor':'pointer'});
    var textBBox = text.getBBox();

    trashIcon = paper.path(getTheTrashIcon()); //get the vector path for the trash tin and draw it 
    trashIcon.attr({fill: '#808080','stroke-width': '0', 'fill-opacity': '0', 'stroke-opacity': '0'});
    trashInvisibleClickRect = paper.rect(0,0,0,0).attr({"stroke-width": 0, fill: "gray", "fill-opacity": 0 });//invisible clicking area behind trash icon

    editIcon  = paper.path(getTheEditIcon()); // get the vector path for the pencil icon and draw it
    editIcon.attr({fill: '#808080','stroke-width': '0', 'fill-opacity': '0', 'stroke-opacity': '0'});
    editInvisibleClickRect = paper.rect(0,0,0,0).attr({"stroke-width": 0, fill: "blue", "fill-opacity": 0 });//invisible clicking area behind edit icon

    var textRect = paper.rect(0, 0, textBBox.width, textBBox.height).attr({"stroke-width": 0, fill: "pink", "fill-opacity": 0 });
    textRect.toFront();

    var allTogetherRect = paper.rect(0, 0, 0, 0).attr({"stroke-width": 0, fill: "pink", "fill-opacity": 0 });

    mySet.push(theDot, text, trashIcon, trashInvisibleClickRect, editIcon, editInvisibleClickRect, textRect, allTogetherRect);

    mySet.co_ords = mySet[0].getBBox();
    mySet.max_x = D_WIDTH + ((CANVAS_WIDTH - D_WIDTH)/2) - (mySet.co_ords.width / 2);
    mySet.min_x = ((CANVAS_WIDTH - D_WIDTH) / 2) + (mySet.co_ords.height / 2);
    mySet.max_y = CANVAS_HEIGHT - ((CANVAS_HEIGHT - D_HEIGHT) / 2) - (mySet.co_ords.height / 2);
    mySet.min_y = ((CANVAS_HEIGHT - D_HEIGHT) / 2) + (mySet.co_ords.width / 2);
    mySet.is_drag = false;
    
    mySet.draggable();

    mySet[0].click(function() {
        currentSet = mySet;
    });
    
    mySet = attachEventHandlersToSet(mySet);
    currentSet = mySet;
    
    var isNewName = true;
    repositionElements(isNewName);

    return mySet;
}

deleteAndCreateNewSet = function (newName, newColor, oldDotPos,newSize) {
	
	var oldDotPosition = oldDotPos;
    var mySet = paper.set(); //define a Raphael Set of vector objects to be passed to draggable
    var theName = newName;
	var curshid = $('#curshid').val();

    theDot = paper.circle(0,0,4);
	//theDot = paper.circle(0,0,newSize);
    theDot.attr({fill: newColor,'cursor':'crosshair'});
	theDot.data('shname', theName);
	theDot.data('shid', curshid);
	theDot.data('shsize', newSize);

    //var text = paper.print(0, 0, theName, theMixPlainBold).attr({"stroke-width": 0, fill: newColor, "font-family": "the_mix_bold-bold, Times", "font-weight": "normal"});
	var text = paper.text(0, 0, theName).attr({"stroke-width": 0, fill: newColor, "font-family": "the_mix_bold-bold, Times", "font-weight": "normal", "font-size":newSize});
    text.data('name', theName);       //save the name in the Set
    text.data('color', newColor);  //and the color
    //text.attr({"font-size": fontSize, 'text-anchor': 'start','cursor':'pointer'});
	text.attr({"font-size": newSize, 'text-anchor': 'start','cursor':'pointer'});
    var textBBox = text.getBBox();

    trashIcon = paper.path(getTheTrashIcon()); //get the vector path for the trash tin and draw it 
    trashIcon.attr({fill: '#808080','stroke-width': '0', 'fill-opacity': '0', 'stroke-opacity': '0'});
    trashInvisibleClickRect = paper.rect(0,0,0,0).attr({"stroke-width": 0, fill: "gray", "fill-opacity": 0 });//invisible clicking area behind trash icon

    editIcon  = paper.path(getTheEditIcon()); // get the vector path for the pencil icon and draw it
    editIcon.attr({fill: '#808080','stroke-width': '0', 'fill-opacity': '0', 'stroke-opacity': '0'});
    editInvisibleClickRect = paper.rect(0,0,0,0).attr({"stroke-width": 0, fill: "blue", "fill-opacity": 0 });//invisible clicking area behind edit icon

    var textRect = paper.rect(0, 0, textBBox.width, textBBox.height).attr({"stroke-width": 0, fill: "gray", "fill-opacity": 0 });
    textRect.toFront();

    var allTogetherRect = paper.rect(0, 0, 0, 0).attr({"stroke-width": 0, fill: "gray", "fill-opacity": 0 });

    mySet.push(theDot, text, trashIcon, trashInvisibleClickRect, editIcon, editInvisibleClickRect, textRect, allTogetherRect);

    mySet.co_ords = mySet[0].getBBox();
    mySet.max_x = D_WIDTH + ((CANVAS_WIDTH - D_WIDTH)/2) - (mySet.co_ords.width / 2);
    mySet.min_x = ((CANVAS_WIDTH - D_WIDTH) / 2) + (mySet.co_ords.height / 2);
    mySet.max_y = CANVAS_HEIGHT - ((CANVAS_HEIGHT - D_HEIGHT) / 2) - (mySet.co_ords.height / 2);
    mySet.min_y = ((CANVAS_HEIGHT - D_HEIGHT) / 2) + (mySet.co_ords.width / 2);
    mySet.is_drag = false;
    
    mySet.draggable();

    mySet[0].click(function() {
        currentSet = mySet;
    });
    
    mySet = attachEventHandlersToSet(mySet);
    currentSet = mySet;
    //var isNewName = true;
    repositionNewElements(oldDotPosition);

    return mySet;
}

redrawNameSet = function(theOrtType,theName,theSHId,curshOrientationValue,curshSizeValue,curshIdValue,node_positionX,node_positionY,node_positionX2,node_positionY2,node_width,node_height,node_positionCX,node_positionCY){
	
	//paper = Raphael('canvas', CANVAS_WIDTH, CANVAS_HEIGHT);
	var nodeTitle = '';
	if(theOrtType=='I')
	{
		nodeTitle = 'Initial Orientation';
	}
	else if(theOrtType=='C')
	{
		nodeTitle = 'Current Orientation';
	}
	else if(theOrtType=='D')
	{
		nodeTitle = 'Desired Orientation';
	}
	
	var mySet = paper.set(); //define a Raphael Set of vector objects to be passed to draggable
	
	theDot = paper.circle(0,0,4);
	//theDot = paper.circle(node_positionCX,node_positionCY,4);
	//theDot = paper.circle(node_positionX+' '+node_positionX2,node_positionY+' * '+node_positionY2,4);
	
	theDot.attr({fill: curshOrientationValue,'cursor':'crosshair'});
	theDot.data('shname', theName);
	theDot.data('shid', theSHId);
	theDot.data('shsize', curshSizeValue);
	
	//var text = paper.print(0, 0, theName, '').attr({"stroke-width": 0, fill: curshOrientationValue, "font-family": "the_mix_bold-bold, Times", "font-weight": "normal", "font-size":90});
	var text = paper.text(0, 0, theName).attr({"title":nodeTitle,"stroke-width": 0, fill: curshOrientationValue, "font-family": "the_mix_bold-bold, Times", "font-weight": "normal", "font-size":curshSizeValue});
	text.data('name', theName);       //save the name in the Set
	text.data('color', curshOrientationValue);  //and the color
	text.attr({"font-size": curshSizeValue, 'text-anchor': 'start','cursor':'pointer'});
	var textBBox = text.getBBox();
	
	trashIcon = paper.path(getTheTrashIcon('false')); //get the vector path for the trash tin and draw it 
	trashIcon.attr({fill: '#808080','stroke-width': '0', 'fill-opacity': '0', 'stroke-opacity': '0'});
	trashInvisibleClickRect = paper.rect(0,0,0,0).attr({"stroke-width": 0, fill: "gray", "fill-opacity": 0 });//invisible clicking area behind trash icon

	editIcon  = paper.path(getTheEditIcon('false')); // get the vector path for the pencil icon and draw it
	editIcon.attr({fill: '#808080','stroke-width': '0', 'fill-opacity': '0', 'stroke-opacity': '0'});
	editInvisibleClickRect = paper.rect(0,0,0,0).attr({"stroke-width": 0, fill: "blue", "fill-opacity": 0 });//invisible clicking area behind edit icon

	var textRect = paper.rect(0, 0, textBBox.width, textBBox.height).attr({"title":nodeTitle,"title":nodeTitle,"stroke-width": 0, fill: "pink", "fill-opacity": 0 });
	textRect.toFront();

	var allTogetherRect = paper.rect(0, 0, 0, 0).attr({"stroke-width": 0, fill: "pink", "fill-opacity": 0 });

	mySet.push(theDot, text, trashIcon, trashInvisibleClickRect, editIcon, editInvisibleClickRect, textRect, allTogetherRect);

	mySet.co_ords = mySet[0].getBBox();
	
	mySet.max_x = D_WIDTH + ((CANVAS_WIDTH - D_WIDTH)/2) - (mySet.co_ords.width / 2);
	mySet.min_x = ((CANVAS_WIDTH - D_WIDTH) / 2) + (mySet.co_ords.height / 2);
	mySet.max_y = CANVAS_HEIGHT - ((CANVAS_HEIGHT - D_HEIGHT) / 2) - (mySet.co_ords.height / 2);
	mySet.min_y = ((CANVAS_HEIGHT - D_HEIGHT) / 2) + (mySet.co_ords.width / 2);
	
	mySet.is_drag = false;
	
	//mySet.draggable();

	mySet[0].click(function() {
		currentSet = mySet;
	});
	
	mySet = attachEventHandlersToSet(mySet);
	currentSet = mySet;

	var isNewName = true;
	//repositionElements(isNewName);
	
	redrawpositionNewElements(node_positionX,node_positionY);
	
	/*var oldDotPosition = '247.98806486157486 150 8.011935138425144  8';	
	repositionNewElements(oldDotPosition);*/

    return mySet;
}

attachEventHandlersToSet = function(mySet) {

    /*
    0 dot
    1 text
    2 trash
    3 trash rect
    4 edit
    5 edit rect
    6 text rect
    7 allTogetherRect
    */

    //invisible text rect behaviour//////////////////
    mySet[6].mouseover(function() { 
      mySet[2].attr({"fill-opacity": 1});
      mySet[4].attr({"fill-opacity": 1});
    });
    mySet[6].mouseout(function() { 
      //mySet[2].attr({"fill-opacity": 0});
      mySet[4].attr({"fill-opacity": 0});
    });

    //invisible edit rectangle behaviour////////////
    mySet[5].mouseover(function() { 
      mySet[2].attr({"fill-opacity": 1});
      mySet[4].attr({"fill-opacity": 1});
    });

    mySet[5].mouseout(function() { 
      mySet[2].attr({"fill-opacity": 0});
      mySet[4].attr({"fill-opacity": 0});
    });

    mySet[5].mousedown(function() { 			
      mySet = triggerEditName(mySet);
    });

    // invisible trash rect behaviour///////////////
    mySet[3].mousedown(function() { //delete set
      //if(mySet.remove()) { counter--; } 
    });

    mySet[3].mouseover(function() { 
      mySet[2].attr({"fill-opacity": 1});
      mySet[4].attr({"fill-opacity": 1});
    });

    mySet[3].mouseout(function() { 
      mySet[2].attr({"fill-opacity": 0});
      mySet[4].attr({"fill-opacity": 0});
    });

    //invisible overall rectangle ( to avoid cursor flickering when hover over gaps between icons and text)
    mySet[7].mouseover(function() { 
      mySet[2].attr({"fill-opacity": 1});
      mySet[4].attr({"fill-opacity": 1});
    });

    mySet[7].mouseout(function() { 
      mySet[2].attr({"fill-opacity": 0});
      mySet[4].attr({"fill-opacity": 0});
    });
    return mySet
}

triggerEditName = function(mySet) {
      //if its IE7 use ordinary old JS to hde or show stuff
      if (navigator.appVersion.indexOf("MSIE 7.")!=-1) {
        document.getElementById("addNameBox").style.display="none";
        document.getElementById("addNameForm").style.display="none";
        document.getElementById("editNameBox").style.display="block";
        document.getElementById("editNameForm").style.display="block";
        $("#editNameBox").css("z-index", "1000");
      } else {
        $("#addNameBox").fadeOut(); 
        $("#addNameBox form").fadeOut();
        $("#editNameBox").fadeIn();
        $("#editNameBox form").fadeIn();
      }

      $("#newName").focus(); //focus on the name edit field when the form pops up

      currentSet = mySet; // assign the global var mySet to make sure we edit the right set
      //mySet[1].attr({fill: "blue"});
      editNameValue.value = currentSet[1].data("name"); //reset the value of the name form field
	  
	  $('#formEditTtitle').html(editNameValue.value);
	  
      var current_pos = mySet[0].getBBox();
      if(current_pos.x < CANVAS_WIDTH / 2 && current_pos.y < CANVAS_HEIGHT / 2) {
        $("#editNameBox").css("top", "320px").css("left", "35px");
      }
      else {
        $("#editNameBox").css("top", "170px").css("left", "35px");
      } 

      return mySet;
}

// Raphael Plugin. Sets become draggable 
Raphael.st.draggable = function(clickedSet) {

  var me = this,
      //coords = me.getBBox();//text bBox

      lx = 0,
      ly = 0;
      ox = 0,
      oy = 0,

      moveFnc = function(dx, dy) {  
        
        lx = dx + ox;
        ly = dy + oy;

        // keep this dragged object within the boundaries of the canvas
        if (lx < me.min_x ) {
          lx = me.min_x;
        } 
        else if ( lx > me.max_x) {
          lx = me.max_x;
        }

        if ( ly < me.min_y ) {
          ly = me.min_y;
        } 
        else if ( ly > me.max_y) {
          ly = me.max_y;
        }
        this.transform('t' + lx + ',' + ly);
       
      },

      startFnc = function(clickedSet) {
        currentSet = me;
        me.is_drag = true;
        var bbox = me[0].getBBox();
        ox = bbox.x;
        oy = bbox.y + (bbox.height/2); 
      },

      endFnc = function() {
        me.is_drag = false;
        repositionElements();
        ox = lx;
        oy = ly;
      };
      this.drag(moveFnc, startFnc, endFnc);
};

Raphael.fn.toJSON = function(callback) {
	var
		data,
		elements = new Array,
		paper    = this
		;
	
	for ( var el = paper.bottom; el != null; el = el.next ) {
		data = callback ? callback(el, new Object) : new Object;
	
		if ( data ) elements.push({
			data:      data,
			type:      el.type,
			attrs:     el.attrs,
			transform: el.matrix.toTransformString(),
			id:        el.id
			});
	}

	var cache = [];
	var o = JSON.stringify(elements, function (key, value) {
		//http://stackoverflow.com/a/11616993/400048
		if (typeof value === 'object' && value !== null) {
			if (cache.indexOf(value) !== -1) {
				// Circular reference found, discard key
				return;
			}
			// Store value in our collection
			cache.push(value);
		}
		return value;
	});
	cache = null;
	return o;
};

Raphael.fn.fromJSON = function(json, callback) {
	var el,	paper = this;

	if ( typeof json === 'string' ) 
	{
		json = JSON.parse(json);
	}
	
	for ( var i in json ) {
		if ( json.hasOwnProperty(i) ) {
			el = paper[json[i].type]()
				.attr(json[i].attrs)
				.transform(json[i].transform);
	
			el.id = json[i].id;
	
			if ( callback ) el = callback(el, json[i].data);
	
			if ( el ) paper.set().push(el);
		}
	}
};

repositionElements = function(isNewName) { //position the trash icon & edir icon after name creation, change or drag
    if(isNewName == true) {
        currentSet[0].transform("t" + 220 + "," + 220);
        repositionName();
    }
    repositionName();
    repositionTrashIcon();
    repositionEditIcon(); 
    repositionAllRectangles();
    stackInOrder();
}

repositionNewElements = function(oldDotPosition) { //position the trash icon & edir icon after name creation, change or drag
    currentSet[0].transform("t" + oldDotPosition.x + "," + oldDotPosition.y);
    repositionName();
    repositionTrashIcon();
    repositionEditIcon(); 
    repositionAllRectangles();
    stackInOrder();
}

redrawpositionNewElements = function(oldDotPositionX,oldDotPositionY) { //position the trash icon & edir icon after name creation, change or drag
    currentSet[0].transform("t" + oldDotPositionX + "," + oldDotPositionY);
    repositionName();
    repositionTrashIcon();
    repositionEditIcon(); 
    repositionAllRectangles();
    stackInOrder();
}
repositionAllRectangles = function() {
    var the = getAllBBoxes();
    currentSet[3].transform("t" + the['trash'].x + "," + the['trash'].y).attr({width: the["trash"].width, height: the["trash"].height});
    currentSet[5].transform("t" + the['edit'].x + "," + the['edit'].y).attr({width: the["edit"].width, height: the["edit"].height});
    currentSet[6].transform("t" + the['text'].x + "," + the['text'].y).attr({width: the["text"].width, height: the["text"].height}); 

    if(isTheDotLeft()) {
        currentSet[7].transform("t" + the['dot'].x + "," + the['text'].y).attr({width: (wholeSetWidth()+3), height: the["text"].height});
    } else {
        currentSet[7].transform("t" + the['edit'].x + "," + the['text'].y).attr({width: wholeSetWidth(), height: the["text"].height});
    }
}

wholeSetWidth = function() {
    var the = getAllBBoxes();
    var width;
    width = the["dot"].width + the["text"].width + the["trash"].width + the["edit"].width + 5;
    return width;
}

stackInOrder= function() {
    currentSet[1].toFront();
    currentSet[7].toFront();
    currentSet[0].toFront();
    currentSet[2].toFront();
    currentSet[4].toFront();
    currentSet[6].toFront();
    currentSet[3].toFront();
    currentSet[5].toFront();
    
}

repositionTrashIcon = function() {
    var the = getAllBBoxes();
    if(isTheDotLeft()) {
        currentSet[2].transform("t" + (the["text"].x + the["text"].width + 3) + "," + (the["text"].y/* + (fontSize/2)*/));
    }
    else {
        currentSet[2].transform("t" + (the["text"].x - the["edit"].width - 3) + "," + (the["text"].y/* + (fontSize/2)*/));
    }
}

repositionEditIcon = function() {
    var the = getAllBBoxes();
    if(isTheDotLeft()) {
        currentSet[4].transform("t" + (the["text"].x + the["text"].width + the["trash"].width + 5) + "," + (the["text"].y/* + (fontSize/2)*/));
    }
    else {
        currentSet[4].transform("t" + (the["text"].x - the["edit"].width - the["trash"].width - 5) + "," + (the["text"].y/* + (fontSize/2)*/));
    }
}

isTheDotLeft = function() {
    var the = getAllBBoxes();
    if(the["dot"].x + 5 < CANVAS_WIDTH / 2) {
        return true;
    }
    else {
        return false;
    }
}

repositionName = function() {

    var the = getAllBBoxes();

    if (!isTheDotLeft()) {
        currentSet[1].transform("t" + (the["dot"].x - the["text"].width - (the["dot"].width / 2)) + "," + (the["dot"].y + 5));
    }

    else {
        currentSet[1].transform("t" + (the["dot"].x + (the["dot"].width + 3)) + "," + (the["dot"].y + 5));
    }
}

getNameTextWidth = function() {
    var nameTextBBox = currentSet[1].getBBox();
    return nameTextBBox.width;
}

show_hint_about_the_dot_once = function() {
    
        var txt="<span id='dot_tip'>Move the dot with your mouse into the right position.</span>";
    
        setTimeout(function() {
            $("#canvas").after(txt);
            $("#dot_tip").fadeIn();
        }, 2500);

        setTimeout(function() {
            $("#dot_tip").fadeOut();
        }, 10000);
    
}

getAllBBoxes = function() {
    var allBBoxes = [];
    allBBoxes["dot"]    =  currentSet[0].getBBox();
    allBBoxes["text"]   =  currentSet[1].getBBox();
    allBBoxes["trash"]  =  currentSet[2].getBBox();
    allBBoxes["edit"]   =  currentSet[4].getBBox();
    return allBBoxes;
}

init = function() {
   
    paper           = Raphael('canvas', CANVAS_WIDTH, CANVAS_HEIGHT),      // init the Raphael canvas
    theMixPlainBold = paper.getFont('TheMixPlainBold');
    size            = document.getElementById('strokeSizeSelect'),
	color           = document.getElementById('strokeStyleSelect'),        // initial color
    addName         = document.getElementById('shname'), 
	addId           = document.getElementById('shid'),// name value
    addNameExit     = document.getElementById('exitAddName'),              // abort add name
    nameSubmit      = document.getElementById('nameSubmit'),               // name submit button
    editNameSubmit  = document.getElementById('nameEdit'),                 // edit name submit button
    editNameValue   = document.getElementById('newName'),                  // edit name new value
    newColor        = document.getElementById('newStrokeStyleSelect'),     // new color
	newSize         = document.getElementById('strokeNewSizeSelect'),      // new size
    generateImage   = document.getElementById('generateImage'),            // not in use yet
    clear           = document.getElementById('clear'),                    // ref to the clear button 

	//---------------------------------------------------------------

    drawBackground();
    drawGrid();
    drawIndexWords();
    drawBackgroundSlogans();
	
}