<?php
	function pr($arr, $return = FALSE)
	{
		if(defined('DEBUG') && DEBUG != 'TRUE') return;
		
		$text = print_r($arr, true);
		if(SITE_AT == 'dev')
			$text = "<pre style='width:98%; padding:0.5%; margin:0.5%; background-color:#e3e3e3; border:1px solid #666;'>".$text."</pre>";
		
			
		if($return)
			return $text;
		else
			echo $text;
	}
	function verifyValues($value)
	{
		global $con;
		if(is_array($value))
			return $value = array_map('verifyValues',$value);
			
		if(is_string($value))
			$value = trim($value);
		
		if(get_magic_quotes_gpc())
			$value = stripslashes($value);
		
		$value = str_replace(array('<script>','</script>','<_script>','</_script>'),'',$value);
		$value = str_replace(array('%3C','%3E','<','>'),'',$value);
		
		$value = strtr( $value, array_flip(get_html_translation_table(HTML_ENTITIES)));
		$value = strip_tags( $value);
		if(isset($con->conLink ))
			$value = mysqli_real_escape_string($con->conLink, $value);
		return $value;
	}
	function encodeData($value)
	{
		$alpha_arr = array('C','O','N','D','M','E','S','L');
		
		$secEncoded = $value;
		$num = rand(0,7);
		
		for($i=1; $i <$num ; $i++)
		{
			$secEncoded = base64_encode($secEncoded);
		}
		
		$secEncoded = $secEncoded . '+' . $alpha_arr[$num];
		
		return $secEncoded = base64_encode($secEncoded);
	}
	function decodedData($value)
	{
		$alpha_arr = array('C','O','N','D','M','E','S','L');
		
		$decoded = base64_decode($value);
		
		list($decoded, $letter) = explode('+',$decoded);
		
		for($i = 0; $i < count($alpha_arr) ; $i++)
		{
			if($alpha_arr[$i] == $letter)
				break;
		}
		
		for($j = 1; $j <$i; $j++)
		{
			$decoded = base64_decode($decoded);
		}
		
		return $decoded;
	}
	function redirectPage($pagename,$postmsg='',$returnVariables='')
	{
		echo "Loading....";
		echo ("<form action='". $pagename ."' method='post' name='frmRdirect' id='frmRdirect'>\n");
		echo ("<input name='msg' id='msg' type='hidden' value='$postmsg'>\n");
		if(is_array($returnVariables))
		{
			foreach($returnVariables as $key=>$val)
			{
				echo ("<input name='$key' id='$key' type='hidden' value='$val'>\n");
			}
		}
		echo "</form>\n";
		echo ("<script type='text/javascript'>\n");		
		echo ("document.getElementById('frmRdirect').submit();\n");
		echo ("</script>\n");
		exit;
	}
	function showMessage($params)
	{
		$msgType = $params['type'];
		$msg = $params['msg'];
		
		return "<div class='inlMsg inlMsg".$msgType."'>".$msg."</div>";
	}
//=======================================================================
	function errorHandeler($errNo)
	{
		$path='include/messages.xml';	
		$count=0;	
		if (file_exists($path)) 
		{
			if(is_readable($path))
			{
				$xml = simplexml_load_file($path);
				foreach($xml->MSG as $a)
				{
					echo $a;
					if($xml->MSG[$count]->ID==$errNo)
						return $xml->MSG[$count]->DESC; 
					$count=$count+1;
				}
			}
		}
		return false;
	}
//========================================
function ValidateEmail($email)
{

$regex = '/([a-z0-9_.-]+)'. # name

'@'. # at

'([a-z0-9.-]+){2,255}'. # domain & possibly subdomains

'.'. # period

'([a-z]+){2,10}/i'; # domain extension 

if($email == '') { 
	return false;
}
else {
$eregi = preg_replace($regex, '', $email);
}

return empty($eregi) ? true : false;
}

//===================================================
	function checkBoxVal($chkBoxName)
	{
		if(isset($_POST[$chkBoxName]))
			 return $_POST[$chkBoxName];
		else
			return 0;
	} 
//=====================================================================	
	function getVar($var)
	{
		$rVar=$_REQUEST[$var];
		$rVar=str_replace("'","''",trim($rVar));
		$rVar=str_replace('"','""',$rVar);
		return $rVar;
	}
//=================================================================================	
function dateCheck($arrayDate)
{

	for($count=0;$count < count($arrayDate);$count++)
	{
		$arr=split('/',$arrayDate[$count]);
		$arrVal=mktime(0, 0, 0, $arr[0],$arr[1],$arr[2]);
		$arrayDate[$count]=$arrVal;
	}
	asort($arrayDate);
	foreach($arrayDate as $Key=>$val)
	{
		return  $Key;
	}
}
//================================================================================
function mySqlDateFormat($rdate)
{
	list($day, $month,$year) = split('[/.-]', $rdate);
	return $year."/".$month."/".$day;
}
function dateFormat($rdate,$formatType = '')
{
	$date = '';
	if(!is_null($rdate))
	{
		switch($formatType)
		{
			case "1":
				$date = date('j M Y g:i:s a',strtotime($rdate));
			break;
			case "2":
				if( ($rdate - 60) < 0)
					$date = $rdate .' seconds';
				else
				{
					$date = (floor($rdate/60) < 10 ? '0' : '').floor($rdate/60).':'.(($rdate%60) < 10 ? '0' : '').($rdate%60);
				}
				
			break;
			default:
				list($year, $month,$day) = split('[/.-]', $rdate);
				$date = $day."/".$month."/".$year;
			break;
		}
	}
	return $date;
}
//=============================For Listing===========================
function splitText($text,$length)
{
		$shortText='';
		if(strlen($text)>$length)
		{
			$shortText=substr($text,0,$length);
			$shortText=$shortText.'...';
			$shortText="<span title='$text'>$shortText</span>";
			return $shortText;
		}
		else
		return $text;
}
//=======Seting secuirty=======================================================
function setMemberSecuirty($page_name = "")
{
	@session_start();
	$arr = array('pagName'=>$page_name);
	if(!isset($_SESSION['member_id']) || $_SESSION['member_id'] <= 0)
		redirectPage("login.php",ERROR_LOGIN_TO_ACC, $arr);
}


//========================Date Format===============================================
 function dateFormat2($rdate)
{
 if(!is_null($rdate))
 {
  list($year, $month,$day) = split('[-./]', $rdate);
  return $day."-".$month."-".$year;
 }
 return '';
}

//======================== No of days between two dates ===============================================

function dateDiff($dateStart, $dateEnd) 
{
    $start = strtotime($dateStart);
    $end = strtotime($dateEnd);
    $days = $end - $start;
    $days = ceil($days/86400);
    return $days;
}

function getSelectOptions($data, $key, $val,$addSelectOne = 'Y')
{
	$totData = count($data);
	
	$retStr = '';
	
	if($addSelectOne == 'Y')
		$retStr = '<option value="">- Select One -</option>';
		
	for($d = 0;$d<$totData; $d++)
	{
		$retStr .= '<option value="'.$data[$d][$key].'">'.$data[$d][$val].'</option>';
	}
	
	return $retStr;
}

function getCommaSeperatedValues($data)
{
	$totData = count($data);
	$counter = 0;
	$retStr = '';
	if($totData>0)
	{
		foreach($data as $key=>$value)
		{
			foreach($value as $key2=>$value2)
			{
				if($counter==0)
				{
					$retStr = $value2;
					$counter++;
				}
				else
				{
					$retStr .= ",".$value2;
					$counter++;
				}
			}
		}
	}
	return $retStr;
}

//=======Seting secuirty=======================
function setSecuirty()
{
	@session_start();
	if(!isset($_SESSION['adminUserID']) || $_SESSION['adminUserID'] <= 0)
			redirectPage("index.php",'Please Login to access Secure Area.');
}
//=======prepage string for sql===============
function prepare(&$arr){
	if(!get_magic_quotes_gpc()){
		foreach($arr as $key=>$val){
			$arr[$key] = addslashes($val);
		}  
	}
}
//=========================CMS Section==============================================
	
	function pageName($page)
	{
		global $con;
		$result = $con->getSingleRow("Select page_name From ".TBL_BASIC_PAGES." Where page_url='$page'");
		return $result['page_name'];
	}
	
	function pageTitle($page)
	{
		global $con;
		$result = $con->getSingleRow("Select page_title From ".TBL_BASIC_PAGES." Where page_url='$page'");
		return $result['page_title'];
	}
	
	function pageMetaTitle($page)
	{
		global $con;
		$result = $con->getSingleRow("Select page_meta_title From ".TBL_BASIC_PAGES." Where page_url='$page'");
		return $result['page_meta_title'];
	}
	
	function pageMetaKeyword($page)
	{
		global $con;
		$result = $con->getSingleRow("Select page_meta_keywords From ".TBL_BASIC_PAGES." Where page_url='$page'");
		return $result['page_meta_keywords'];
	}
	
	function pageMetaDescription($page)
	{
		global $con;
		$result = $con->getSingleRow("Select page_meta_keywords_description From ".TBL_BASIC_PAGES." Where page_url='$page'");
		return $result['page_meta_keywords_description'];
	}	
	
	function pageHeading($page)
	{
		global $con;
		$result = $con->getSingleRow("Select page_heading From ".TBL_BASIC_PAGES." Where page_url='$page'");
		return $result['page_heading'];
	}
			
	function pageContent($page)
	{
		global $con;
		$result = $con->getSingleRow("Select page_content From ".TBL_BASIC_PAGES." Where page_url='$page'");
		return $result['page_content'];
	}

	function pageBanner($page)
	{
		global $con;
		$result = $con->getSingleRow("Select page_banner From ".TBL_BASIC_PAGES." Where page_url='$page'");
		return $result['page_banner'];
	}
	
//=========================End of CMS Section=======================================
?>